VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Trace"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private mo_ListMethod As Collection
Private Const BeginMethod = ""
Private Const OnlyComponent = ""
Private Const Trace_Application = True
Private ml_FileNumber As Long
Private mb_Trace As Boolean
Private mb_Error As Boolean
Private ml_Begin As Long
Private mb_TraceError As Boolean

Private mo_ArmDb As Object
Private mo_ArmDbTrace As Object
Private ms_ConnectString As String
Private ms_UID As String
Private mb_Created As Boolean
Private mb_use_framework_connection As Boolean

Public Property Set ArmDb(ByRef lo_local_connection As Object)
    
    CapMouseOff
    
    If Not (lo_local_connection Is Nothing) Then
        Set mo_ArmDb = lo_local_connection
        mb_use_framework_connection = True
    End If
    
Trace_End:
    CapMouseOn
End Property

Public Property Let ConnectString(as_ConnectString As String)

    CapMouseOff
    
    ms_UID = ConnectionStringValidation(as_ConnectString)
    If ms_UID = "" Then GoTo Trace_End
    
    ms_ConnectString = as_ConnectString
    
    'Affectation aux objets
    
Trace_End:
    CapMouseOn
End Property

Public Function InsertParameters(as_Line As String, av_Variable, Optional ab_FirstLevel = True) As String
Dim i As Integer

    On Error Resume Next

    If Not IsMissing(av_Variable) Then
        If Not IsArray(av_Variable) Then
            as_Line = as_Line & """" & av_Variable & """"
        Else
            If ab_FirstLevel = False Then as_Line = as_Line & "("
            For i = 0 To UBound(av_Variable)
                as_Line = InsertParameters(as_Line, av_Variable(i), False)
                If i < UBound(av_Variable) Then as_Line = as_Line & ","
            Next
            If ab_FirstLevel = False Then as_Line = as_Line & ")"
        End If
    End If
    InsertParameters = as_Line
End Function

Public Sub WriteTraceProc(ab_Begin As Boolean, as_Procedure As String, ParamArray aa_Variable())
Dim ls_Line As String
Dim i As Integer

    #If CapDebug Then
    
        On Error Resume Next
        
        If Trace_Application = False Then Exit Sub
    
        If BeginMethod = as_Procedure And ab_Begin = True Then
            mb_Trace = True
        End If
        
        If mb_Trace = False And as_Procedure <> "Trace" Then Exit Sub
        
        If OnlyComponent <> "" And InStr(1, as_Procedure, OnlyComponent, vbTextCompare) = 0 Then Exit Sub
        
        ls_Line = Format((timer - ml_Begin), "00000.0") & vbTab
        
        ls_Line = ls_Line & IIf(ab_Begin = True, "Begin" & vbTab, "End" & vbTab)
        
        If ab_Begin = True Then
            mo_ListMethod.Add as_Procedure
        Else
            'Find the level of the method
            For i = mo_ListMethod.Count To 1 Step -1
                If mo_ListMethod.Item(i) = as_Procedure Then
                    mo_ListMethod.Remove i
                    Exit For
                End If
                mo_ListMethod.Remove i
            Next
            If mo_ListMethod.Count > 0 Then ls_Line = ls_Line & vbTab
        End If
        
        For i = 1 To mo_ListMethod.Count - 1
            ls_Line = ls_Line & vbTab
        Next
        
        ls_Line = ls_Line & as_Procedure
        ls_Line = InsertParameters(ls_Line, Array(aa_Variable))
        
        Print #ml_FileNumber, ls_Line
        
        If mo_ListMethod.Count = 1 And BeginMethod <> "" Then
            mb_Trace = False
        End If
    
    #End If
    
End Sub

Public Sub WriteTraceError(al_ErrNumber As Long, as_ErrDescription As String, as_Procedure As String, ParamArray aa_Variable())
Dim ls_Line As String
Dim i As Integer
Dim ll_FileNumber As Long
Dim ls_Request As String
Dim lb_Created As Boolean

    On Error Resume Next

    'debug.assert False

    mb_Error = True
    
    If UBound(aa_Variable) > 0 Then
        WriteTraceProc False, as_Procedure, "Error", al_ErrNumber, as_ErrDescription, aa_Variable
    Else
        WriteTraceProc False, as_Procedure, "Error", al_ErrNumber, as_ErrDescription
    End If

    ls_Line = Date & vbTab & Time & vbTab & Format((timer - ml_Begin), "00000.0") & vbTab
    ls_Line = ls_Line & as_Procedure & "("
    ls_Line = InsertParameters(ls_Line, Array(al_ErrNumber, as_ErrDescription, aa_Variable))
    ls_Line = ls_Line & ")"
    
    #If CapDebug Then
        ll_FileNumber = FreeFile
        Open "c:\Capture_Error.rtf" For Append As ll_FileNumber
        
        Print #ll_FileNumber, ls_Line
        
        Close #ll_FileNumber
    #End If

    #If CapDebug Then
        ' Only visible by it
        If ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) = True Then
            Call ASC_SendMessage(mo_ArmDb, "E", 922, "#An error occured during the use of capture, please contact IT Team. Error code = ", "Line : " & ls_Line)
            ASC_DisconnectFromDB mo_ArmDb, ms_UID, mb_Created
        End If
    #Else
        If ASC_ConnectToDB(mo_ArmDbTrace, ms_ConnectString, lb_Created) = True Then
            ls_Request = "EXEC ZLog_ins2 'Capture','" & ms_UID & " : " & ls_Line & "',NULL"
            mo_ArmDbTrace.ExecuteSQL ls_Request
            ASC_DisconnectFromDB mo_ArmDbTrace, ms_UID, lb_Created
        End If
    #End If
    
    #If LIVE Then
    #Else
        Call MsgBox("Fatal Error, please make a screenshot and report to IT Application Support." & vbCrLf & ls_Line, vbCritical)
        End
    #End If

    
End Sub

Public Sub WriteTraceInfo(as_Procedure As String, ParamArray aa_Variable())
Dim ls_Line As String
Dim i As Integer

    #If CapDebug Then
        
        On Error Resume Next
    
        If Trace_Application = False Then Exit Sub
    
        On Error GoTo WriteTraceInfo_Err
        
        If mb_Trace = False And as_Procedure <> "Trace" Then Exit Sub
        
        If OnlyComponent <> "" And InStr(1, as_Procedure, OnlyComponent, vbTextCompare) = 0 Then Exit Sub
        
        ls_Line = Format((timer - ml_Begin), "00000.0") & vbTab & "Info" & vbTab
        
        For i = 1 To mo_ListMethod.Count - 1
            ls_Line = ls_Line & vbTab
        Next
        
        ls_Line = ls_Line & vbTab & as_Procedure
        ls_Line = InsertParameters(ls_Line, Array(aa_Variable))
        
        Print #ml_FileNumber, ls_Line
        
    #End If
        
    Exit Sub
    
WriteTraceInfo_Err:

End Sub

Public Sub WriteTraceSQLError(ByRef ao_Armdb As Object, as_Procedure As String, ParamArray aa_Variable())
Dim ls_Line As String
Dim i As Integer
Dim ll_Error As Long
Dim ls_Error As String
Dim ll_FileNumber As Long
Dim ls_GeneralError As String
Dim la_Line() As String
Dim ll_ErrorNumber As Long
Dim ls_Request As String
Dim lb_Created As Boolean
Dim lv_ErrCode As Variant
Dim lv_ErrMsg As Variant

    On Error Resume Next

    'debug.assert False

    mb_Error = True
    ls_GeneralError = vbCrLf
    ll_ErrorNumber = 0
    
    lv_ErrCode = ao_Armdb.SQLErrorCodes
    lv_ErrMsg = ao_Armdb.SQLErrorMessages
    
    Dim ll_Count As Long
    
    
    ll_Count = UBound(lv_ErrCode)
    
    'Do While ao_Armdb.SQLErrorMessages(ll_ErrorNumber)
    For ll_ErrorNumber = 0 To ll_Count
        ll_Error = lv_ErrCode(ll_ErrorNumber)
        ls_Error = lv_ErrMsg(ll_ErrorNumber)
        ls_GeneralError = ls_GeneralError & vbCrLf & ls_Error
        If UBound(aa_Variable) > 0 Then
            WriteTraceInfo as_Procedure, "Error", ll_Error, ls_Error, aa_Variable
        Else
            WriteTraceInfo as_Procedure, "Error", ll_Error, ls_Error
        End If
    
        ls_Line = Date & vbTab & Time & vbTab & Format((timer - ml_Begin), "00000.0") & vbTab
        ls_Line = ls_Line & as_Procedure & "("
        ls_Line = InsertParameters(ls_Line, Array(ll_Error, ls_Error, aa_Variable))
        ls_Line = ls_Line & ")"
        
        ReDim Preserve la_Line(ll_ErrorNumber)
        la_Line(ll_ErrorNumber) = ls_Line

        #If CapDebug Then
            ll_FileNumber = FreeFile
            Open "c:\Capture_Error.rtf" For Append As ll_FileNumber
            
            Print #ll_FileNumber, ls_Line
            
            Close #ll_FileNumber
        #End If
    Next

    #If CapDebug Then
        If ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) = True Then
            Call ASC_SendMessage(mo_ArmDb, "E", 924, "#The following database access error occurred : ", ls_GeneralError)
            ASC_DisconnectFromDB mo_ArmDb, ms_UID, mb_Created
        End If
    #Else
        If ASC_ConnectToDB(mo_ArmDbTrace, ms_ConnectString, lb_Created) = True Then
            For i = 0 To UBound(la_Line)
                ls_Request = "EXEC ZLog_ins2 'Capture'," & FormatSqlStringParameter(ms_UID & " SQL: " & la_Line(i)) & ",NULL"
                mo_ArmDbTrace.ExecuteSQL ls_Request
            Next
            ASC_DisconnectFromDB mo_ArmDbTrace, ms_UID, lb_Created
        End If
        

    #End If
    
    Call MsgBox("Fatal Error, please make a screenshot and report to IT Application Support." & vbCrLf & ls_Line, vbCritical)
    End
    
End Sub

Public Sub Load_A_Com()

    #If CapDebug Then
    
        On Error Resume Next
    
        If Trace_Application = False Then Exit Sub
        ml_Begin = timer
        Set mo_ListMethod = New Collection
        
        ml_FileNumber = FreeFile
        Open "c:\Capture.rtf" For Append As ml_FileNumber
        
        If BeginMethod = "" Then mb_Trace = True
        
        If Not go_Trace Is Nothing Then WriteTraceProc True, "Trace", Date, Time
        
    #End If

End Sub

Public Sub Unload_A_Com()

    #If CapDebug Then
        On Error Resume Next
    
        If Trace_Application = False Then Exit Sub
        
        WriteTraceProc False, "Trace", Date, Time
    
        Set mo_ListMethod = Nothing
        Close #ml_FileNumber
    
        If mb_Error = True Then
            MsgBox "The Trace has detected there was an Error in the application. See the log c:\capture.rtf"
        End If
    #End If
    
End Sub

